#ifndef Z3D_HIERARCHY_INCLUDED
#define Z3D_HIERARCHY_INCLUDED

// Objects         - Set of objects
// Default string  - unused
// param1          - char* child_name or child** child_name
// param2          - char* parent_name or child** parent_name
// returns zero on success, non-zero on fail

// all relations are: param1->param2 where param1 is a child.
// char* value of NULL is used as root

//------------------------------------------------
// Adding relation.
// To add relation, pass name of the parent object
// in param2, and name of the child object in param1.
// e.g. sysp((sRequestType)Z3D_HIERARCHY_ADDRELATION,
//           Objects, NULL,
//           Objects->ObjSet[i].ObjectName,//child
//           Objects->ObjSet[j].ObjectName);//parent
#define Z3D_HIERARCHY_ADDRELATION       0x00008020

//------------------------------------------------
// Removing relation.
// To remove relation, pass name of the parent object
// in param2, and name of the child object in param1.
// e.g. sysp((sRequestType)Z3D_HIERARCHY_REMOVERELATION,
//           Objects, NULL,
//           Objects->ObjSet[i].ObjectName,//child
//           Objects->ObjSet[j].ObjectName);//parent
#define Z3D_HIERARCHY_REMOVERELATION    0x00008021

// for param2 parent. Result is in char** param1.
// *param1 of NULL used to get first child. NULL returned
// in *param1 is "no more child"
//------------------------------------------------
// Searching the children.
// Find children of a certain object, make the first
// call and pass address of char* NULL in param1
// and name of the parent object in param2. (The memory
// for param1 is allocated)
// char* pChild = NULL;
// e.g. sysp((sRequestType)Z3D_HIERARCHY_GETNEXTCHILD,
//           Objects, NULL,
//           &pChild,
//           Objects->ObjSet[j].ObjectName);//parent
// To obtain next child, make the same call, but make
// sure pChild points to non-NULL string. If it points
// to the NULL string, then the last child was obtained
// before.
#define Z3D_HIERARCHY_GETNEXTCHILD      0x00008022

// for param1. result in char** param2
//------------------------------------------------
// Obtaning parent.
// To obtain the parent, pass the name of the child in
// in param1, and the address of (char*) in param2.
// If there is parent for object with name param1, then
// It's parent object name is copied to param2. (The
// memory is allocated).
// char* pParent = NULL;
// e.g. sysp((sRequestType)Z3D_HIERARCHY_GETPARENT,
//           Objects, NULL,
//           "object01", //child
//           &pParent);//parent
// if (NULL != (*pParent))
// {... there is the parent.
#define Z3D_HIERARCHY_GETPARENT         0x00008023

//------------------------------------------------
// Children.
// To find out whether the node has any child, pass the
// name of the node in param2. Zero is returned if no
// children were found.
// if (0!=sysp((sRequestType)Z3D_HIERARCHY_HASCHILD,
//           Objects, NULL,
//           NULL, //child
//           "Object01"))
// {... there are children
#define Z3D_HIERARCHY_HASCHILD          0x00008024

//------------------------------------------------
// To find out how many children the node has, pass the
// name of the node in param2.
// int num = sysp((sRequestType)Z3D_HIERARCHY_COUNTCHILDREN,
//           Objects, NULL,
//           NULL, //child
//           "Object01");
// Note, only direct children are conted. In relation
// A <- B <- C, the node A has only one child (B).
#define Z3D_HIERARCHY_COUNTCHILDREN     0x00008025

//------------------------------------------------
// To find out how many children the node has at all
// (including indirect), pass the name of the node in param2.
// int num = sysp((sRequestType)Z3D_HIERARCHY_COUNTALLCHILDREN,
//           Objects, NULL,
//           NULL, //child
//           "Object01");
// In relation A <- B <- C, the node A has two
// children (B and C), B has one child (C).
#define Z3D_HIERARCHY_COUNTALLCHILDREN  0x00008026

//from param1 to param2

//------------------------------------------------
// Organizing hierarchy.
// To move a bunch of children from one parent to
// another, pass the name of current parent in param1
// and the name of desired parent object in param2.
// e.g. sysp((sRequestType)Z3D_HIERARCHY_MOVECHILDREN,
//           Objects, NULL,
//           "Left Node"
//           "Right Node");
// ...moves all children from "Left Node" to the
// "Right Node".
#define Z3D_HIERARCHY_MOVECHILDREN      0x00008027

//------------------------------------------------
// To move single child node from one parent to
// another, pass the name of the node-object in
// param1 and the name of desired parent in param2.
// e.g. sysp((sRequestType)Z3D_HIERARCHY_MOVENODE,
//           Objects, NULL,
//           "Node"
//           "Box");
// ...makes the "Node" direct child of the "Box"
#define Z3D_HIERARCHY_MOVENODE          0x00008028

//------------------------------------------------
// Displaying editor/browser
// call system request with the following constant:
#define Z3D_HIERARCHY_SHOWEDITOR        0x00008029

//------------------------------------------------
// Enabling/Disable 'affect editing' feature
// call system request with the following constant:
#define Z3D_HIERARCHY_AFFECT_EDITING    0x0000802A
#define Z3D_HIERARCHY_UNAFFECT_EDITING  0x0000802B

//------------------------------------------------
// Determining relations.
// To find out whether the node is direct child of
// some parent node, pass the child object's name
// in param1 and the parent's obejct name in param2:
// if (0!=sysp((sRequestType)Z3D_HIERARCHY_ISDIRECTCHILD,
//           Objects, NULL,
//           "Box1",
//           "The Bunch"))
// {... Box1 is direct child of "The Bunch"
#define Z3D_HIERARCHY_ISDIRECTCHILD     0x0000802C

//------------------------------------------------
// To find out whether the node is indirect child of
// some parent node, pass the child object's name
// in param1 and the parent's obejct name in param2:
// if (0!=sysp((sRequestType)Z3D_HIERARCHY_ISINDIRECTCHILD,
//           Objects, NULL,
//           "Box1",
//           "The Bunch"))
// {... Box1 is eitehr direct or indirect
//      child of "The Bunch".
#define Z3D_HIERARCHY_ISINDIRECTCHILD   0x0000802D


#endif /*Z3D_HIERARCHY_INCLUDED*/
